'use client';

import { LoadingOutlined, PlusOutlined } from '@ant-design/icons';
import { IResponse } from '@services/api-request';
import { Upload } from 'antd';
import type { RcFile } from 'antd/es/upload/interface';
import { useEffect, useState } from 'react';

import { checkImageBeforeUpload, getBase64 } from 'src/lib';
import { profileService } from 'src/services';

export interface IAvatarUpdate {
  /**
   * profile if, otherwise it will get current user avatar
   */
  profile?: any;
  onChange: (fileId: string) => void;
}

export function AvatarUpdate({
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  profile = undefined,
  onChange
}: IAvatarUpdate) {
  const [loading, setLoading] = useState(false);
  const [imageUrl, setImageUrl] = useState<string>();

  const handleUpload = async (file: RcFile) => {
    setLoading(true);
    const res = await profileService.getAvatarUploadUrl();
    const avatar = await profileService.uploadAvatar(res.data.uploadUrl, file) as IResponse<any>;
    onChange(avatar.data.fileId)
    // TODO - load current profile and reload avatar?
    setLoading(false);
  };

  const beforeUpload = async (file: RcFile) => {
    if (!checkImageBeforeUpload(file)) return false;

    getBase64(file, (url) => {
      setImageUrl(url);
    });

    // do upoad the file
    await handleUpload(file);
    return false;
  };

  useEffect(() => {
    if (profile) {
      setImageUrl(profile.avatar);
    }
  }, [profile]);

  const uploadButton = (
    <div>
      {loading ? <LoadingOutlined /> : <PlusOutlined />}
      <div style={{ marginTop: 8 }}>Upload</div>
    </div>
  );

  return (
    <Upload
      name="avatar"
      listType="picture-circle"
      className="avatar-uploader"
      showUploadList={false}
      beforeUpload={beforeUpload}
    >
      {imageUrl ? <img src={imageUrl} alt="avatar" style={{ width: '100%' }} /> : uploadButton}
    </Upload>
  );
}
