'use client';

import { IPerformer } from 'src/interfaces';
import { getResponseError } from 'src/lib';
import { performerService } from 'src/services';
import { Button, Space, Table, TablePaginationConfig, message } from 'antd';
import Link from 'next/link';
import { useRouter, useSearchParams } from 'next/navigation';
import { formatDate } from '@lib/date';
import { useState } from 'react';
import StatusBadge from '@components/common/status-badge';

type Props = {
  data: IPerformer[];
  total: number;
  pageSize: number;
};

export function PerformerTableList({ data, total, pageSize }: Props) {
  const [selectedRowKeys, setSelectedRowKeys] = useState<React.Key[]>([]);
  const [loading, setLoading] = useState(false);
  const [updating, setUpdating] = useState(false);
  const router = useRouter();

  const searchParams = useSearchParams();
  const page = searchParams.get('page');

  const handleChange = (pagination: TablePaginationConfig) => {
    const current = pagination.current && !isNaN(pagination.current) ? pagination.current : 1;
    router.push(`/pornstar?page=${current}&pageSize=${pagination.pageSize}`);
  };

  const handleRemove = async (id: string) => {
    try {
      if (!window.confirm('Are you sure you want to delete this pornstar?')) return;
      await performerService.delete(id);
      message.success('Deleted Successfully.');
      router.refresh();
    } catch (e) {
      const error = await Promise.resolve(e);
      message.error(getResponseError(error));
    }
  };

  const removeALl = async () => {
    // ajax request after empty completing
    try {
      if (!window.confirm('Are you sure you want to delete all selected pornstars?')) return;
      setLoading(true);
      await selectedRowKeys.reduce(async (lp, id) => {
        await lp;
        await performerService.delete(id as string);
        return Promise.resolve();
      }, Promise.resolve());
      router.refresh();
    } catch (e) {
      const error = await Promise.resolve(e);
      message.error(getResponseError(error));
    } finally {
      setLoading(false);
      setSelectedRowKeys([]);
    }
  };

  const onSelectChange = (newSelectedRowKeys: React.Key[]) => {
    setSelectedRowKeys(newSelectedRowKeys);
  };

  const handleUpdate = async (id: string, field: string, value: any) => {
    try {
      setUpdating(true);
      await performerService.update(id, { [field]: value });
      router.refresh();
    } catch (e) {
      const error = await Promise.resolve(e);
      message.error(getResponseError(error));
    } finally {
      setUpdating(false);
    }
  }

  const rowSelection = {
    selectedRowKeys,
    onChange: onSelectChange
  };
  const hasSelected = selectedRowKeys.length > 0;

  const dataSource = data.map(d => ({
    ...d,
    key: d._id
  })) as IPerformer[];

  const columns = [
    {
      title: 'Name',
      dataIndex: 'name',
      key: 'name'
    },
    {
      title: 'Gender',
      dataIndex: 'gender',
      key: 'gender'
    },
    // {
    //   title: 'Bio',
    //   dataIndex: 'bio',
    //   key: 'bio'
    // },
    {
      title: 'Status',
      dataIndex: 'status',
      key: 'status',
      render: (status: string, record: IPerformer) => {
        const { _id } = record;
        const isActive = status === 'active';
        const statusUpdate = isActive ? 'inactive' : 'active';
        return (<span style={{ cursor: 'pointer' }} onClick={() => handleUpdate(_id, 'status', statusUpdate)}><StatusBadge active={isActive} activeText="Active" inActiveText="Inactive" /></span>)
      }
    },
    {
      title: 'Updated At',
      dataIndex: 'updatedAt',
      key: 'updatedAt',
      render(date: Date) {
        return <span>{formatDate(date)}</span>;
      }
    },
    {
      title: 'Action',
      key: 'action',
      render: (record: any) => (
        <Space>
          <Link href={`/pornstar/update/${record._id}`}>
            <Button type="primary">Update</Button>
          </Link>
          <Button onClick={() => handleRemove(record._id)}>Delete</Button>
        </Space>
      )
    }
  ];

  return (
    <div>
      <div style={{ marginBottom: 16 }}>
        <Button type="primary" danger onClick={removeALl} disabled={!hasSelected} loading={loading}>
          Delete Performers
        </Button>
        <span style={{ marginLeft: 8 }}>
          {hasSelected ? `Selected ${selectedRowKeys.length} items` : ''}
        </span>
      </div>
      <Table
        className="ant-border-space"
        columns={columns}
        dataSource={dataSource}
        pagination={{
          pageSize: pageSize,
          total: total,
          current: page ? Number(page) : 1
        }}
        onChange={handleChange}
        rowSelection={rowSelection}
        loading={loading || updating}
      />
    </div>
  );
}
