'use client';

import DebounceSelect from '@components/common/debounce-select-options';
import { performerService } from '@services/performer.service';
import { type SelectProps } from 'antd';
import { IPerformer, Res } from 'src/interfaces';

interface IProps {
  fieldName: string;
  onChange: Function;
  selectProps?: SelectProps;
}

export default function PerformerSelection({ onChange: onChangeHandler, fieldName, selectProps }: IProps) {

  async function getPerformer(q = '') {
    const { data: performerResp } = await performerService.search({
      q,
      limit: 100
    }) as Res;

    if (performerResp.data && performerResp.data.length) {
      return performerResp.data.map((p: IPerformer) => ({ label: p?.name, value: p._id }))
    }
    return [];
  }

  return (
    <DebounceSelect
      fetchOptions={(search: string = '') => getPerformer(search)}
      {...selectProps}
      onChange={(value) => onChangeHandler(fieldName, value)}
    />
  )
}