import { useState, useEffect, useRef } from 'react';
import videojs from 'video.js';
import Player from 'video.js/dist/types/player';
import s from './video-player.module.scss';

export function VideoPlayer({ ...props }) {
  const [isPlayed, setIsPlayed] = useState(false);

  const videoRef = useRef<HTMLVideoElement>();
  const playerRef = useRef<Player>();

  const handleOnPlay = () => {
    if (isPlayed) return;
    !isPlayed && setIsPlayed(true);
  };

  useEffect(() => {
    playerRef.current = videojs(videoRef.current as HTMLVideoElement, { ...props });
    playerRef.current.on('play', handleOnPlay);

    return () => {
      if (playerRef.current) {
        playerRef.current.dispose();
        playerRef.current.off('play', handleOnPlay);
      }
    };
  // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  return (
    <div className={s['videojs-player']}>
      <div data-vjs-player>
        <video
          muted
          controls
          disablePictureInPicture
          ref={videoRef as any}
          className="video-js"
        />
      </div>
    </div>
  );
}
