'use client';
import classnames from 'classnames';
import React, { ReactNode } from 'react';

import s from './page.module.scss';
import { Breadcrumb } from 'antd';
import Link from 'next/link';
import { BreadcrumbItemType } from 'antd/lib/breadcrumb/Breadcrumb';

interface IProps {
  loading?: boolean;
  className?: string;
  inner?: boolean;
  children: any;
  title?: string;
  extra?: ReactNode;
  breadcrumbs?: BreadcrumbItemType[];
}

export default function Page(payload: IProps) {
  const {
    className,
    children,
    breadcrumbs = [],
    loading = false,
    inner = true,
    title = '',
    extra
  } = payload;
  return (
    <div
      className={classnames(s.page, className, {
        contentInner: inner,
        loading
      })}
    >
      {breadcrumbs.length > 0 && (
        <Breadcrumb
          items={breadcrumbs}
          itemRender={(route) => {
            // const last =
            //   breadcrumbs.findIndex(
            //     (breadcrum) => breadcrum.key === route.key
            //   ) ===
            //   breadcrumbs.length - 1;
            return route.href ? (
              <Link key={route.key} href={route.href as any}>{route.title}</Link>
            ) : (
              <span key={route.key}>{route.title}</span>
            );
          }}
        />
      )}
      <div className={classnames(s.head, 'd-flex')}>
        <h1>{title}</h1>
        <div className={classnames(s.rightHead, 'm-auto')}>
          {extra}
        </div>
      </div>
      {children}
    </div>
  );
}
