import { FileAddOutlined, LoadingOutlined } from '@ant-design/icons';
import { message, Upload } from 'antd';
import { useState } from 'react';
interface IProps {
  fieldName?: string;
  uploadUrl?: string;
  headers?: any;
  onUploaded?: Function;
  accept?: string;
  uploadImmediately?: boolean;
  onFileSelected?: Function;
  maxSize?: number;
  signUploadUrl?: Function;
}

export default function FileUpload({
  fieldName,
  uploadUrl,
  headers,
  onUploaded,
  accept = '*',
  uploadImmediately,
  onFileSelected = () => { },
  maxSize
}: IProps) {
  const [loading, setLoading] = useState(false);
  const [fileUrl, setFileUrl] = useState('');

  const beforeUpload = (file: File) => {
    const isLt2M = file.size / 1024 / 1024 < (maxSize || Number(process.env.MAX_SIZE_FILE || 20));
    if (!isLt2M) {
      message.error(`File must smaller than ${maxSize || process.env.MAX_SIZE_FILE || 20}MB!`);
    }
    if (!uploadImmediately) {
      onFileSelected(file);
      return false;
    }
    return isLt2M && uploadUrl;
  }

  const handleChange = (info: any) => {
    if (info.file.status === 'uploading') {
      setLoading(true);
      return;
    }
    if (info.file.status === 'done') {
      // Get this url from response in real world.
      setFileUrl(info.file.response.data ? info.file.response.data.url : 'Done!');
      setLoading(false);
      onUploaded
        && onUploaded({
          response: info.file.response
        });
    }
  };

  const uploadButton = (
    <div>
      {loading ? <LoadingOutlined /> : <FileAddOutlined />}
    </div>
  );

  return (
    <Upload
      name={fieldName}
      listType="picture-card"
      className="avatar-uploader"
      showUploadList={true}
      action={uploadUrl}
      beforeUpload={beforeUpload}
      onChange={handleChange}
      headers={headers}
      accept={accept}
    >
      {fileUrl ? <span>Click to download</span> : uploadButton}
    </Upload>
  );
}
