import { Button, Upload, UploadProps } from 'antd';
import { UploadOutlined, LoadingOutlined } from '@ant-design/icons';
import { useState } from 'react';
import s from './file-upload.module.scss';

interface IProps {
  uploadProps: UploadProps;
  uploading?: boolean;
  onUploaded?: Function;
}

export default function FileUploadCustom({ uploadProps, uploading = false, onUploaded }: IProps) {
  const [loading, setLoading] = useState(uploading);

  const onChange = (info: any) => {
    if (info.file.status === 'uploading') {
      setLoading(true);
      return;
    }
    if (info.file.status === 'done') {
      setLoading(false);
      onUploaded
        && onUploaded({
          response: info.file.response
        });
    }
  };

  const uploadButton = (
    <Button icon={loading ? <LoadingOutlined /> : <UploadOutlined />}>
      {loading ? 'Uploading...' : 'Upload'}
    </Button>
  );

  return (
    <div className={s['upload-custom-container']}>
      <Upload
        {...uploadProps}
        onChange={onChange}
      >
        {uploadButton}
      </Upload>
    </div >
  )
}