import { capitalizeFirstLetter } from '@lib/string';
import { Tag } from 'antd';

const FILE_STATUS = {
  UPLOADED: 'uploaded',
  PENDING_UPLOAD: 'pending_upload',
  PROCESSING: 'processing',
  PROCESSED: 'processed',
  ERROR: 'error'
};

interface Props {
  status: string;
}

export function FileStatus({status}: Props) {
  if (status ===  FILE_STATUS.ERROR) {
    return <Tag color="error">{capitalizeFirstLetter(status)}</Tag>
  }
  if (status ===  FILE_STATUS.PROCESSED) {
    return <Tag color="#52c41a">{capitalizeFirstLetter(status)}</Tag>
  }
  if (status ===  FILE_STATUS.PROCESSING) {
    return <Tag color="processing">{capitalizeFirstLetter(status)}</Tag>
  }
  if (status ===  FILE_STATUS.PROCESSING) {
    return <Tag color="warning">{capitalizeFirstLetter(status)}</Tag>
  }

  return <Tag>{capitalizeFirstLetter(status)}</Tag>
}