'use client';

import {
  Form,
  Button,

  Input,
  message,
  Select
} from 'antd';
import { FormInstance } from 'antd/lib/form';
import { useEffect, useRef } from 'react';
import {
  useFormStatus,
  useFormState
} from 'react-dom';
import { redirect } from 'next/navigation';
import { ActionState, IPost } from 'src/interfaces';
import dynamic from 'next/dynamic';
const SUNEDITOR = dynamic(() => import('@components/common/suneditor'), {
  ssr: false
});


interface IProps {
  data?: any | undefined;
  onFinish: any
}

export function EmailTemplateForm({ data = undefined, onFinish }: IProps) {
  const [state, formAction] = useFormState<ActionState, IPost>(onFinish, {});
  const formRef = useRef<FormInstance>(null);
  const { pending } = useFormStatus();

  function setFormVal(field: string, val: any) {
    const instance = formRef.current as FormInstance;
    instance.setFieldsValue({
      [field]: val
    });
  }

  useEffect(() => {
    if (state.success) {
      message.success('Updated Successfully');
      redirect('/email-template');
    } else {
      state.message && message.error(state.message);
    }
  }, [state]);

  useEffect(() => {
    if (data) {
      formRef.current?.setFieldsValue(data);
    }
  }, [data]);

  return (
    <Form
      ref={formRef}
      onFinish={(values) => formAction({ ...data, ...values })}
      initialValues={{
        subject: '',
        content: '',
        layout: ''
      }}
      layout="vertical"
    >
      <Form.Item
        name="subject"
        label="Subject"
        rules={[{ required: true, message: 'Enter the email template subject!' }]}
      >
        <Input placeholder="Title" />
      </Form.Item>
      <Form.Item
        label="Content"
        name="content"
        rules={[{ required: true, message: 'Required!' }]}
      >
        <SUNEDITOR
          richTextEditorHtml={data?.content || ''}
          onRichTextEditorChange={({ html }: any) => setFormVal('content', html)}
          displayMode="EDIT"
        />
      </Form.Item>
      <Form.Item
        name="layout"
        label="Layout"
        rules={[{ required: true, message: 'Please select layout!' }]}
      >
        <Select placeholder={'Select layout'}>
          <Select.Option value="layouts/default">Default</Select.Option>
          <Select.Option value="blank">Blank</Select.Option>
        </Select>
      </Form.Item>
      <Form.Item>
        <Button
          type="primary"
          htmlType="submit"
          loading={pending}
          disabled={pending}
        >
          Submit
        </Button>
      </Form.Item>
    </Form>
  );
}
