'use client';

import { Button, Space, Table } from 'antd';
import Link from 'next/link';
import style from './table-list.module.css';

type Props = {
  data: any[];

};

export default function EmailTemplateTableList({ data }: Props) {
  const columns = [
    {
      title: 'Name',
      dataIndex: 'name',
      key: 'name',
      width: 300,
      ellipsis: true
    },
    {
      title: 'Subject',
      dataIndex: 'subject',
      key: 'subject',
      ellipsis: true,
      width: 300
    },
    {
      title: 'Action',
      key: 'action',
      width: 100,
      className:style['antd-column'],
      render: (record: any) => (
        <Space>
          <Link href={`/email-template/update/${record._id}`}>
            <Button type="primary">Update</Button>
          </Link>
        </Space>
      )
    }
  ];

  return (
    <Table

      className={style['ant-border-space']}
      columns={columns}
      dataSource={data}
      scroll={{x: 700}}
    />
  );
}
