import { Card, Col, Row, Space, Statistic } from 'antd';

interface IProps {
  stats: Record<string, any>;
}

export default function Stats({ stats }: IProps) {
  const { video, category } = stats;
  return (
    <Row gutter={16}>
      <Col md={12} sm={12} xs={24}>
        {video && (
          <Card bordered={false} title={<Space size={6}>VIDEO STATISTICS</Space>}>
            <Space size={6} direction='vertical' style={{ width: '100%' }}>
              <Statistic
                title="Total"
                value={video?.total || 0}
              />
              <Statistic
                title="New Videos "
                value={video?.total || 0}
              />
            </Space>
          </Card>
        )}
      </Col>
      <Col md={12} sm={12} xs={24}>
        {category && (
          <Card bordered={false} title={<Space size={6}>CATEGORIES STATISTICS</Space>}>
            <Space size={6} direction='vertical' style={{ width: '100%' }}>
              <Statistic
                title="Video Categories"
                value={category?.videoCategories}
              />
            </Space>
          </Card>
        )}
      </Col>
    </Row>
  )
}