'use client';

import { Menu } from 'antd';
import { useEffect, useState } from 'react';

interface IProps {
  mode?: 'horizontal' | 'vertical';
  data: Array<{
    label: string;
    key: string;
  }>;
  onChange: Function;
  defaultTab?: string;
  className?: string;
};

export default function Tabs({
  mode = 'horizontal',
  data = [],
  onChange = () => { },
  defaultTab = ''
}: IProps) {
  const [selectedKeys, setSelectedKeys] = useState('');

  useEffect(() => {
    if (defaultTab) {
      setSelectedKeys(defaultTab);
    };
    if (!defaultTab && data.length > 0) {
      setSelectedKeys(data[0].key);
    }
  }, []);

  const _onChange = (menu: any) => {
    setSelectedKeys(menu.key);
    onChange(menu.key);
  }
  return data.length > 0 && (
    <Menu onClick={(menu) => _onChange(menu)} selectedKeys={[selectedKeys]} mode={mode}>
      {data.map((item: {
        label: string;
        key: string;
      }) => <Menu.Item key={item.key}>{item.label}</Menu.Item>)}
    </Menu>
  )
}