import { Badge } from 'antd';

interface IProps {
  active: boolean;
  activeText: string;
  inActiveText: string;
  activeBackgroundColor?: string;
  inActiveBackgroundColor?: string;
}

export default function StatusBadge({
  active,
  activeText,
  inActiveText,
  activeBackgroundColor = '#52c41a',
  inActiveBackgroundColor = '#f5222d'
}: IProps) {
  return <Badge count={active ? activeText : inActiveText} color={active ? activeBackgroundColor : inActiveBackgroundColor} />
}