'use client';

import { Row, Col, Input } from 'antd';
import s from './search-filter.module.scss';
import { useCallback } from 'react';
import { usePathname, useRouter, useSearchParams } from 'next/navigation';
import debounce from 'lodash/debounce';

interface IProps {
  fieldname?: string
}

export default function SearchFilter({ fieldname = 'q' }: IProps) {
  const pathname = usePathname();
  const searchParams = useSearchParams();
  const router = useRouter();

  const createQueryString = useCallback(
    (name: string, value: string) => {
      const params = new URLSearchParams(searchParams)
      params.set(name, value || '')
      return params.toString()
    },
    [searchParams]
  )

  const onFilter = debounce((value: string) => {
    const url = `${pathname}?${createQueryString(fieldname, value)}`;
    router.push(url)
  }, 500)



  return (
    <div className={s['search-filter']}>
      <Row gutter={24}>
        <Col lg={8} md={8} xs={24}>
          <Input
            placeholder="Enter keyword"
            onChange={(e) =>
              onFilter(e.target.value)
            }
          />
        </Col>
      </Row>
    </div>
  );
}
