'use client';

import DebounceSelect from '@components/common/debounce-select-options';
import { categoryService } from '@services/category.service';
import { type SelectProps } from 'antd';
import { ICategory, Res } from 'src/interfaces';

interface IProps {
  fieldName: string;
  onChange: Function;
  selectProps?: SelectProps;
  group?: string;
}

export default function CategorySelection({ onChange: onChangeHandler, fieldName, selectProps, group }: IProps) {

  async function getCategorys(q = '') {
    const { data: categoryResp } = await categoryService.search({
      group,
      status: 'active',
      q,
      limit: 100
    }) as Res;

    if (categoryResp.data && categoryResp.data.length) {
      return categoryResp.data.map((t: ICategory) => ({ label: t?.title || t.slug, value: t._id }))
    }
    return [];
  }

  return (
    <DebounceSelect
      fetchOptions={(search: string = '') => getCategorys(search)}
      {...selectProps}
      onChange={(value) => onChangeHandler(fieldName, value)}
    />
  )
}