'use client';

import { EyeInvisibleOutlined, EyeTwoTone } from '@ant-design/icons';
import { getResponseError } from '@lib/utils';
import {
  Button,
  Form,
  Input,
  Checkbox,
  message,
  Alert,
  Row,
  Col
} from 'antd';
import Image from 'next/image';
import Link from 'next/link';
import { useRouter } from 'next/navigation';
import { useState } from 'react';
import { useConfig } from 'src/context/config.context';
import { authService } from 'src/services';

export default function FormLogin({
  settings
}: {
  settings?: Record<string, any>
}) {
  const router = useRouter();
  const [remember, setRemember] = useState(false);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState<string | null>();
  const { logoUrl } = useConfig();

  const onSubmit = async (data: any) => {
    try {
      setLoading(true);
      setError(null);
      await authService.login(data) as any;
      message.success('Login successfully.');
      router.push('/dashboard');
    } catch (e) {
      setError(getResponseError(await Promise.resolve(e)));
    } finally {
      setLoading(false);
    }
  };

  return (
    <Row gutter={[0, 0]} justify="space-around">
      <Col
        xs={{ span: 24, offset: 0 }}
        lg={{ span: 10, offset: 2 }}
        md={{ span: 12 }}
        style={{ margin: '70px 0 0 0', maxWidth: '100%' }}
        className='text-center'
      >
        <Image
          src={logoUrl || settings?.logoUrl || '/logo.png'}
          alt="logo"
          unoptimized
          width={300}
          height={120}
          style={{
            objectFit: 'contain'
          }}
        />
        <h3 className="font-regular text-muted text-center">
          ADMIN PANEL
        </h3>
        <Form
          onFinish={onSubmit}
          layout="vertical"
          className="row-col"
          style={{
            padding: 25
          }}
        >
          <Form.Item
            className="username"
            label="Email address or Username"
            name="username"
            rules={[
              {
                required: true,
                message: 'Please input your email address or username!'
              }
            ]}
          >
            <Input style={{ height: '50px' }} placeholder="Email or username" />
          </Form.Item>

          <Form.Item
            className="password"
            label="Password"
            name="password"
            rules={[
              {
                required: true,
                message: 'Please input your password!'
              }
            ]}
          >
            <Input.Password
              placeholder="Password"
              // eslint-disable-next-line react/no-unstable-nested-components
              iconRender={(visible) => (visible ? <EyeTwoTone /> : <EyeInvisibleOutlined />)}
            />
          </Form.Item>

          <Form.Item
            name="remember"
            className="align-center a"
            valuePropName="checked"
          >
            <div style={{ display: 'flex', justifyContent: 'space-between' }}>
              <Checkbox onChange={() => setRemember(!remember)}>Remember me</Checkbox>

              <Link href="/auth/forgot" className="text-dark font-bold">
                Forgot Password?
              </Link>
            </div>
          </Form.Item>
          <Form.Item>
            {error && <Alert showIcon type='error' message={error} />}
          </Form.Item>
          <Form.Item>
            <Button
              type="primary"
              htmlType="submit"
              style={{ width: '100%' }}
              loading={loading}
              disabled={loading}
            >
              SIGN IN
            </Button>
          </Form.Item>
        </Form>
      </Col>
    </Row>
  );
}
