'use client';

import { getResponseError } from '@lib/utils';
import { authService } from '@services/auth.service';
import {
  Button,
  Col,
  Form,
  Input,
  message,
  Row
} from 'antd';
import Image from 'next/image';
import Link from 'next/link';
import { useRouter } from 'next/navigation';
import { useState } from 'react';

export default function FormForgot({
  settings
}: {
  settings?: Record<string, any>
}) {
  const route = useRouter();
  const [loading, setLoading] = useState(false);
  const onFinish = async (email: string) => {
    try {
      setLoading(true);
      await authService.forgotPassword(email);
      message.success('Please check inbox for password reset instructions.');
      setLoading(false);
      route.push('/auth/login');
    } catch (error) {
      setLoading(false);
      const e = await Promise.resolve(error);
      message.error(getResponseError(e) || 'Account not found, please recheck the email.');
    }
  };
  return (
    <Row gutter={[0, 0]} justify="space-around">
      <Col
        xs={{ span: 24, offset: 0 }}
        lg={{ span: 6, offset: 2 }}
        md={{ span: 12 }}
        style={{ margin: '70px 0 0 0', maxWidth: '100%' }}
      >
        <Image
          src={settings?.logoUrl || '/logo.png'}
          alt="logo"
          width={300}
          height={120}
          style={{
            objectFit: 'contain',
            display: 'block',
            margin: '0 auto'
          }}
        />
        <h3 className="font-regular text-muted text-center">
          ADMIN PANEL
        </h3>
        <Form
          onFinish={(e) => onFinish(e)}
          layout="vertical"
          className="row-col"
        >
          <Form.Item
            className="email"
            label="Email address"
            name="email"
            rules={[
              {
                required: true,
                message: 'Please enter email address.'
              },
              {
                type: 'email',
                message: 'The input is not valid E-mail!'
              }
            ]}
          >
            <Input style={{ height: '50px' }} placeholder="youremail@example.com" />
          </Form.Item>
          <Form.Item>
            <Button
              type="primary"
              htmlType="submit"
              style={{ width: '100%' }}
              loading={loading}
            >
              SUBMIT
            </Button>
          </Form.Item>
          <Form.Item>
            <Link href="/auth/login" className="text-dark font-bold" style={{}}>
              <Button block>Login</Button>
            </Link>
          </Form.Item>
        </Form>
      </Col>
    </Row>

  );
}
