import { ConfigProvider } from 'antd';
import type { Metadata } from 'next';
import { ConfigProvider as SiteConfigProvider} from 'src/context/config.context';

import StyledComponentsRegistry from 'src/lib/antd-registry';
import { settingService } from '@services/setting.service';

import './globals.css';
import './main.css';
import './responsive.css';

export async function generateMetadata(): Promise<Metadata> {
  const {
    data: settings = {
      siteName: 'xStreamer',
      logoUrl: '',
      favicon: '',
      paygateSupport: ['ccbill'],
      homeTitle: 'Home',
      homeMetaKeywords: '',
      homMetaDescription: '',
      headerScript: '',
      afterBodyScript: '',
      gaCode: ''
    }
  } = await settingService.public();

  return {
    title: {
      default: settings.siteName,
      template: `%s | ${settings.siteName}`
    },
    description: settings.homMetaDescription,
    keywords: settings.homeMetaKeywords
  };
}

export default async function RootLayout({
  children
}: {
  children: React.ReactNode;
}) {
  const {data: settings = {
    siteName: 'xStreamer',
    logoUrl: '',
    favicon: '',
    paygateSupport: ['ccbill'],
    homeTitle: 'Home',
    homeMetaKeywords: '',
    homMetaDescription: '',
    headerScript: '',
    afterBodyScript: '',
    gaCode: ''
  }} = await settingService.public('');

  return (
    <html lang="en">
      <head>
        {settings.favicon && (
          <link rel="icon" type="image/x-icon" href={settings.favicon}></link>
        )}
      </head>
      <StyledComponentsRegistry>
        <ConfigProvider pagination={{showSizeChanger: false}}>
          <SiteConfigProvider settings={settings}><body>{children}</body></SiteConfigProvider>
        </ConfigProvider>
      </StyledComponentsRegistry>
    </html>
  );
}
