import { Metadata } from 'next';
import { unstable_noStore as noStore } from 'next/cache';
import { settingService } from '@services/setting.service';
import FormLogin from 'src/components/auth/login-form';

export const fetchCache = 'force-no-store';

export async function generateMetadata(): Promise<Metadata> {
  const settings = await settingService.valueByKeys(['favicon']);
  return {
    title: 'Login',
    icons: {
      icon: settings.data.favicon || '/logo.png'
    }
  };
}

export default async function SignIn() {
  noStore();
  const settings = await settingService.valueByKeys(['logoUrl']);

  return (
    <FormLogin settings={settings.data} />
  );
}
