import { Layout } from '@lib/antd';
import dynamic from 'next/dynamic';

const Footer = dynamic(() => import('src/layout/footer'), { ssr: false })

export default async function AuthLayout({
  children // will be a page or nested layout
}: {
  children: React.ReactNode
}) {
  return (
    <Layout className="layout-default layout-signin" style={{ height: '100vh', marginLeft: '0' }}>
      <div className="signin">
        {children}
      </div>
      <Footer />
    </Layout>
  );
}
