import { Metadata } from 'next';
import { unstable_noStore as noStore } from 'next/cache';
import FormForgot from 'src/components/auth/forgot';

import { settingService } from '@services/setting.service';

export const fetchCache = 'force-no-store';

export async function generateMetadata(): Promise<Metadata> {
  const settings = await settingService.valueByKeys(['favicon']);
  return {
    title: 'Forgot Password',
    icons: {
      icon: settings.data.favicon || '/logo.png'
    }
  };
}

export default async function Forgot() {
  // this is v14, In version 15, we recommend using connection instead of unstable_noStore.
  noStore();
  const settings = await settingService.valueByKeys(['logoUrl']);

  return (
    <FormForgot settings={settings.data} />
  );
}
