import Page from 'src/components/layout/page';
import { VideoTableList } from '@components/video/table-list';
import { videoService } from 'src/services';
import { ISearch } from 'src/interfaces';
import { cookies } from 'next/headers';
import Link from 'next/link';
import { Button } from 'antd';
import { redirect } from 'next/navigation';
import SearchFilterVideo from '@components/video/search-filter';

interface SearchParams extends ISearch {
  q: string;
  status: string;
  categoryIds: string;
  performerIds: string;
  tags: string;
}

interface IProps {
  searchParams: SearchParams;
}

export const metadata = {
  title: 'Videos'
};

export default async function VideoPage({
  searchParams: { page = 1, q = '', categoryIds = '', pageSize = 10, sort = 'desc', sortBy = 'updatedAt', performerIds = '', tags = '' }
}: IProps) {
  const cookieStore = cookies();
  const token = cookieStore.get('token');
  const { error, data } = await videoService.search(
    { limit: pageSize, offset: (page - 1) * pageSize, q, categoryIds, sort, sortBy, performerIds, tags },
    {
      Authorization: token?.value || ''
    }
  );

  if (error) return null;

  const { total } = data as any;
  const totalPages = Math.ceil(total / pageSize);

  if (page > totalPages && total > 0) {
    redirect(`/video?page=${totalPages}`);
  }

  return (
    <Page
      title="Manage Existing Video"
      extra={
        <Link href="/video/create">
          <Button type="primary">Add a new Video</Button>
        </Link>
      }
      breadcrumbs={[
        {
          title: 'Dashboard',
          key: 'dashboard',
          href: '/'
        },
        {
          title: 'Manage Existing Video',
          key: 'video'
        }
      ]}
    >
      <SearchFilterVideo />
      <VideoTableList {...data} pageSize={pageSize} />
    </Page>
  );
}
