'use client';

import { Tabs, message } from 'antd';
import type { TabsProps } from 'antd';
import { notFound } from 'next/navigation';
import { useEffect, useState } from 'react';

import { ProfileForm } from 'src/components/profile/profile-form';
import { ISearch } from 'src/interfaces';
import { profileService } from 'src/services';
import UpdatePasswordForm from '@components/profile/update-password';
import Page from '@components/layout/page';

interface SearchParams extends ISearch {
  id: string;
}

interface IProps {
  searchParams: SearchParams
}
export default function ProfileUpdate({
  searchParams
}: IProps) {
  const { id } = searchParams;
  const [dataProfile, setDataProfile] = useState<any>();
  const [loading, setLoading] = useState<any>(false);
  // eslint-disable-next-line consistent-return
  const loadData = async () => {
    try {
      const res = await profileService.findById(id);
      setDataProfile(res.data as any);
      if (res.error) {
        return notFound();
      }
      setLoading(true);
    } catch (error) {
      message.error(error as any);
    }
  };

  useEffect(() => {
    loadData();
  }, []);

  const items: TabsProps['items'] = [
    {
      key: 'basic',
      label: 'Basic info',
      children: loading && (
        <ProfileForm
          profile={dataProfile?.data}
        />
      )
    },
    {
      key: 'password',
      label: 'Change Password',
      children: loading && <UpdatePasswordForm profile={dataProfile?.data} />
    }
  ];

  return (
    <Page
      title="Update User"
      breadcrumbs={[
        {
          title: 'Dashboard',
          key: 'dashboard',
          href: '/'
        },
        {
          title: 'Users',
          key: 'profile',
          href: '/user'
        },
        {
          title: 'Update User',
          key: 'update-profile'
        }
      ]}>
      <Tabs defaultActiveKey="basic" tabPosition="top" items={items} />
    </Page>
  );
}
