import Page from 'src/components/layout/page';
import SearchFilter from '@components/common/search-filter';
import ProfileTable from '@components/profile/profiles-table';
import { cookies } from 'next/headers';
import { profileService } from '@services/profile.service';
import { ISearch } from 'src/interfaces';
import { redirect } from 'next/navigation';

interface SearchParams extends ISearch {
  q: string;
  status: string;
  gender: string;
}

interface IProps {
  searchParams: SearchParams;
}

export const metadata = {
  title: 'Users'
};

export default async function ProfilePage({
  searchParams: { page = 1, q = '', sort = 'desc', sortBy = 'updatedAt' }
}: IProps) {

  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const pageSize = 10;

  const { error, data } = await profileService.search(
    { limit: pageSize, offset: (page - 1) * pageSize, q, sort, sortBy },
    {
      Authorization: token?.value || ''
    }
  );

  if (error) return null;

  const { total } = data as any;
  const totalPages = Math.ceil(total / pageSize);

  if (page > totalPages && total > 0) {
    redirect(`/user?page=${totalPages}`);
  }

  return (
    <Page
      title="Manage Users"
      breadcrumbs={[
        {
          title: 'Dashboard',
          key: 'dashboard',
          href: '/'
        },
        {
          title: 'Manage Users',
          key: 'profile'
        }
      ]}
    >
      <SearchFilter />
      <ProfileTable {...(data as any)} pageSize={pageSize} />
    </Page>
  );
}
