import Page from 'src/components/layout/page';
import { tagService } from 'src/services';
import { ISearch } from 'src/interfaces';
import { cookies } from 'next/headers';
import SearchFilter from 'src/components/common/search-filter';
import Link from 'next/link';
import { Button } from 'antd';
import { TagTableList } from '@components/tag/table-list';
import { redirect } from 'next/navigation';

interface SearchParams extends ISearch {
  q: string;
}

interface IProps {
  searchParams: SearchParams;
}

export const metadata = {
  title: 'Tags'
};

export default async function TagPage({
  searchParams: { page = 1, q = '', sort = '', sortBy = '' }
}: IProps) {
  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const pageSize = 10;

  const { error, data } = await tagService.search(
    { limit: pageSize, offset: (page - 1) * pageSize, q, sortBy, sort },
    {
      Authorization: token?.value || ''
    }
  );

  if (error) return null;

  const { total } = data as any;
  const totalPages = Math.ceil(total / pageSize);

  if (page > totalPages && total > 0) {
    redirect(`/tag?page=${totalPages}`);
  }

  return (
    <Page
      title="Manage Tag"
      extra={
        <Link href="/tag/create">
          <Button type="primary">Add a new Tag</Button>
        </Link>
      }
      breadcrumbs={[
        {
          title: 'Dashboard',
          key: 'dashboard',
          href: '/'
        },
        {
          title: 'Manage Tag',
          key: 'tag'
        }
      ]}
    >
      <SearchFilter />
      <TagTableList {...(data as any)} pageSize={pageSize} />
    </Page>
  );
}
