
import Page from 'src/components/layout/page';
import { createTag } from 'src/actions';
import { FormTag } from '@components/tag/form-tag';

export const metadata = {
  title: 'Create Tag'
};

function TagCreate() {
  return (
    <>
      <Page
        title="Create Tag"
        breadcrumbs={[
          {
            title: 'Dashboard',
            key: 'dashboard',
            href: '/'
          },
          {
            title: 'Tag',
            key: 'tag',
            href: '/tag'
          },
          {
            title: 'Create Tag',
            key: 'create-tag'
          }
        ]}>
        <FormTag onFinish={createTag} />
      </Page>
    </>
  );
}

export default TagCreate;