import Page from '@components/layout/page';
import SettingForm from '@components/setting/setting-form';
import SettingTab from '@components/setting/setting-tab';
import { settingService } from '@services/setting.service';
import { cookies } from 'next/headers';
import { ISearch, ISetting } from 'src/interfaces';

interface SearchParams extends ISearch {
  group: string
}

interface IProps {
  searchParams: SearchParams;
}

export const metadata = {
  title: 'Settings'
};

export default async function Setting({
  searchParams: { group = 'general' }
}: IProps) {
  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const { error, data } = await settingService.all(group, {
    Authorization: token?.value || ''
  });

  if (error) return null;

  return (
    <Page>
      <SettingTab defaultTab={group} />
        <SettingForm settings={data as ISetting[]} group={group} />
    </Page>
  )
}