import Page from 'src/components/layout/page';
import { postService } from 'src/services';
import { ISearch } from 'src/interfaces';
import { cookies } from 'next/headers';
import SearchFilter from 'src/components/common/search-filter';
import Link from 'next/link';
import { Button } from 'antd';
import { PostTableList } from '@components/post/table-list';
import { redirect } from 'next/navigation';

interface SearchParams extends ISearch {
  q: string;
  status: string;
  gender: string;
}

interface IProps {
  searchParams: SearchParams;
}

export const metadata = {
  title: 'Posts'
};

export default async function PostPage({
  searchParams: { page = 1, q = '', sort = '', sortBy = '' }
}: IProps) {
  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const pageSize = 10;

  const { error, data } = await postService.search(
    { limit: pageSize, offset: (page - 1) * pageSize, q, sort, sortBy },
    {
      Authorization: token?.value || ''
    }
  );

  if (error) return null;

  const { total } = data as any;
  const totalPages = Math.ceil(total / pageSize);

  if (page > totalPages && total > 0) {
    redirect(`/post?page=${totalPages}`);
  }

  return (
    <Page
      title="Manage Post"
      extra={
        <Link href="/post/create">
          <Button type="primary">Add a new Post</Button>
        </Link>
      }
      breadcrumbs={[
        {
          title: 'Dashboard',
          key: 'dashboard',
          href: '/'
        },
        {
          title: 'Manage Post',
          key: 'post'
        }
      ]}
    >
      <SearchFilter />
      <PostTableList {...(data as any)} pageSize={pageSize} />
    </Page>
  );
}
