
import Page from 'src/components/layout/page';
import { createPost } from 'src/actions';
import { FormPost } from '@components/post/form-post';

export const metadata = {
  title: 'Create Post'
};

function PostCreate() {
  return (
    <>
      <Page
        title="Create Post"
        breadcrumbs={[
          {
            title: 'Dashboard',
            key: 'dashboard',
            href: '/'
          },
          {
            title: 'Post',
            key: 'post',
            href: '/post'
          },
          {
            title: 'Create Post',
            key: 'create-post'
          }
        ]}>
        <FormPost onFinish={createPost} />
      </Page>
    </>
  );
}

export default PostCreate;