import Page from 'src/components/layout/page';
import { performerService } from 'src/services';
import { ISearch } from 'src/interfaces';
import { cookies } from 'next/headers';
import SearchFilter from 'src/components/common/search-filter';
import Link from 'next/link';
import { Button } from 'antd';
import { PerformerTableList } from '@components/performer/table-list';
import { redirect } from 'next/navigation';

interface SearchParams extends ISearch {
  q: string;
  status: string;
  gender: string;
}

interface IProps {
  searchParams: SearchParams;
}

export const metadata = {
  title: 'Pornstars'
};

export default async function PerformerPage({
  searchParams: { page = 1, q = '', pageSize = 10 }
}: IProps) {
  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const { error, data } = await performerService.search(
    { limit: pageSize, offset: (page - 1) * pageSize, q },
    {
      Authorization: token?.value || ''
    }
  );

  if (error) return null;

  const { total } = data as any;
  const totalPages = Math.ceil(total / pageSize);

  if (page > totalPages && total > 0) {
    redirect(`/pornstar?page=${totalPages}`);
  }

  return (
    <Page
      title="Manage Pornstars"
      extra={
        <Link href="/pornstar/create">
          <Button type="primary">Add a new Pornstar</Button>
        </Link>
      }
      breadcrumbs={[
        {
          title: 'Dashboard',
          key: 'dashboard',
          href: '/'
        },
        {
          title: 'Manage Pornstars',
          key: 'performer'
        }
      ]}
    >
      <SearchFilter />
      <PerformerTableList {...(data as any)} pageSize={pageSize} />
    </Page>
  );
}
