import { MainLayoutContextProvider } from 'src/context/main-layout.context';
import { ProfileContextProvider } from 'src/context/profile.context';
import Main from 'src/layout/main';
import { Suspense } from 'react';

export default function RootLayout({
  children
}: {
  children: React.ReactNode;
}) {
  return (
    <>
      <MainLayoutContextProvider>
        <Suspense>
          <ProfileContextProvider>
            <Main>{children}</Main>
          </ProfileContextProvider>
        </Suspense>
      </MainLayoutContextProvider>
    </>
  );
}
