import Page from 'src/components/layout/page';
import { emailTemplateService } from 'src/services';
import { ISearch } from 'src/interfaces';
import { cookies } from 'next/headers';
import SearchFilter from 'src/components/common/search-filter';
// import Link from 'next/link';
// import { Button } from 'antd';
import EmailTemplateTableList from '@components/email-template/table-list';

interface SearchParams extends ISearch {
  q: string;
}

interface IProps {
  searchParams: SearchParams;
}

export const metadata = {
  title: 'Email Templates'
};

export default async function EmailTemplatePage({
  searchParams: { page = 1, q = '' }
}: IProps) {
  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const pageSize = 100;

  const { error, data } = await emailTemplateService.findAll(
    { limit: pageSize, offset: (page - 1) * pageSize, q },
    {
      Authorization: token?.value || ''
    }
  );
  if (error) return null;

  return (
    <Page
      title="Manage Email Templates"
      // extra={
      //   <Link href="/email-template/create">
      //     <Button type="primary">Add a new Email Template</Button>
      //   </Link>
      // }
      breadcrumbs={[
        {
          title: 'Dashboard',
          key: 'dashboard',
          href: '/'
        },
        {
          title: 'Manage Email Templates',
          key: 'emailTemplate'
        }
      ]}
    >
      <SearchFilter />
      <EmailTemplateTableList data={data || []} />
    </Page>
  );
}
