import Stats from '@components/dashboard/stats';
import Page from '@components/layout/page';
import { statsService } from '@services/stats.service';
import { cookies } from 'next/headers';

export const metadata = {
  title: 'Dashboard'
};

export default async function Dashboard() {
  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const { error, data } = await statsService.search(
    {},
    {
      Authorization: token?.value || ''
    }
  );

  if (error) return null;
  return (
    <Page title="Dashboard">
      <Stats stats={data} />
    </Page>
  );
}
