
import Page from 'src/components/layout/page';
import { createCategory } from 'src/actions';
import { FormCategory } from '@components/category/form-category';

export const metadata = {
  title: 'Create Category'
};

function CategoryCreate({ searchParams: { group = 'video' } }: any) {
  return (
    <>
      <Page
        title="Create Category"
        breadcrumbs={[
          {
            title: 'Dashboard',
            key: 'dashboard',
            href: '/'
          },
          {
            title: 'Category',
            key: 'category',
            href: `/category?group=${group}`
          },
          {
            title: 'Create Category',
            key: 'create-category'
          }
        ]}
      >
        <FormCategory onFinish={createCategory} />
      </Page>
    </>
  );
}

export default CategoryCreate;