
import Page from 'src/components/layout/page';
import { createAd } from 'src/actions';
import { FormAd } from '@components/ad/form-ad';

export const metadata = {
  title: 'Create Ad'
};

function AdCreate() {
  return (
    <>
      <Page
        title="Create Ad"
        breadcrumbs={[
          {
            title: 'Dashboard',
            key: 'dashboard',
            href: '/'
          },
          {
            title: 'Ad',
            key: 'ad',
            href: '/ad'
          },
          {
            title: 'Create Ad',
            key: 'create-ad'
          }
        ]}
      >
        <FormAd onFinish={createAd} />
      </Page>
    </>
  );
}

export default AdCreate;