'use server';

import { revalidatePath, revalidateTag } from 'next/cache';
import { ActionState, IVideo } from 'src/interfaces';
import { fetcher } from './lib';

export async function createVideo(prevState: ActionState, data: IVideo) {
  const res = await fetcher('/admin/videos', 'POST', data);
  revalidatePath('/video');
  revalidateTag('video');
  return res;
}

export async function updateVideo(prevState: ActionState, data: IVideo) {
  const res = await fetcher('/admin/videos/' + data._id, 'PUT', data);
  revalidatePath('/video');
  revalidateTag('video');
  return res;
}