'use server';

import { revalidatePath } from 'next/cache';
import { ActionState, IPerformer } from 'src/interfaces';
import { fetcher } from './lib';

export async function createTag(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/tags', 'POST', data);
  revalidatePath('/tag');
  return res;
}

export async function updateTag(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/tags/' + data._id, 'PUT', data);
  revalidatePath('/tag');
  return res;
}