'use server';

import { revalidatePath } from 'next/cache';
import { ActionState, IPerformer } from 'src/interfaces';
import { fetcher } from './lib';

export async function createPost(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/posts', 'POST', data);
  revalidatePath('/post');
  return res;
}

export async function updatePost(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/posts/' + data._id, 'PUT', data);
  revalidatePath('/post');
  return res;
}