import { cookies } from 'next/headers'
import { getResponseError, isUrl } from '../lib';
import { Res } from 'src/interfaces';

export async function fetcher<T>(
  url: string,
  method?: string,
  body?: any,
  headers?: { [key: string]: string },
  options = {}
): Promise<Res<T>> {
  const verb = (method || 'POST').toUpperCase();

  const cookieStore = cookies();
  const token = cookieStore.get('token');

  const updatedHeader = {
    'Content-Type': 'application/json',
    // TODO - check me
    Authorization: token?.value || '',
    ...(headers || {})
  };
  const baseApiEndpoint =
    process.env.API_ENDPOINT || process.env.NEXT_PUBLIC_API_ENDPOINT;
  return fetch(isUrl(url) ? url : `${baseApiEndpoint}${url}`, {
    method: verb,
    headers: updatedHeader,
    body: body ? JSON.stringify(body) : null,
    cache: 'no-store',
    ...options
  })
    .then((res) => res.json())
    .then((res) => {
      if (res.statusCode && res.statusCode !== 200) {
        return {
          error: res.error || res.statusCode,
          message: getResponseError(res),
          data: undefined,
          success: false
        };
      }

      return {
        error: null,
        message: '',
        data: res.data,
        success: true
      };
    })
    .catch((error) => ({
      error,
      message: getResponseError(error),
      data: undefined,
      success: false
    }));
}