'use server';

import { revalidatePath, revalidateTag } from 'next/cache';
import { ActionState, IPerformer } from 'src/interfaces';
import { fetcher } from './lib';

export async function createCategory(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/categories', 'POST', data);
  revalidatePath('/category');
  revalidateTag('category');
  return res;
}

export async function updateCategory(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/categories/' + data._id, 'PUT', data);
  revalidatePath('/category');
  revalidateTag('category');
  return res;
}