'use server';

import { revalidatePath, revalidateTag } from 'next/cache';
import { ActionState, IPerformer } from 'src/interfaces';
import { fetcher } from './lib';

export async function createAd(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/ads', 'POST', data);
  revalidatePath('/ad');
  revalidateTag('ad');
  return res;
}

export async function updateAd(prevState: ActionState, data: IPerformer) {
  const res = await fetcher('/admin/ads/' + data._id, 'PUT', data);
  revalidatePath('/ad');
  revalidateTag('ad');
  return res;
}