/** @type {import('next').NextConfig} */
const nextConfig = {
  distDir: 'dist/.next',
  poweredByHeader: false,
  eslint: {
    // Warning: This allows production builds to successfully complete even if
    // your project has ESLint errors.
    ignoreDuringBuilds: true
  },
  reactStrictMode: false,
  experimental: {
    serverActions: {
      bodySizeLimit: '2mb'
    },
    appDir: true
  },
  async redirects() {
    return [
      {
        source: '/',
        destination: '/dashboard',
        permanent: true
      }
    ]
  },
  images: {
    domains: ['tn.thegay.com'],
    unoptimized: true
  },
  env: {
    // Will be available on both server and client
    API_ENDPOINT: process.env.API_ENDPOINT,
    FRONT_OFFICE_ENDPOINT: process.env.FRONT_OFFICE_ENDPOINT || 'http://localhost:8081',
    BACK_OFFICE_ENDPOINT: process.env.BACK_OFFICE_ENDPOINT || 'http://localhost:8082',
    SOCKET_ENDPOINT: process.env.SOCKET_ENDPOINT || process.env.API_ENDPOINT,
    MAX_SIZE_IMAGE: process.env.MAX_SIZE_IMAGE || 5,
    MAX_SIZE_FILE: process.env.MAX_SIZE_FILE || 100,
    MAX_SIZE_TEASER: process.env.MAX_SIZE_TEASER || 200,
    MAX_SIZE_VIDEO: process.env.MAX_SIZE_VIDEO || 2000,
    VIDEO_FILE_ACCEPT: process.env.VIDEO_FILE_ACCEPT || 'video/*,.mkv,.flv'
  },
  async headers() {
    return [
        {
          source: '/api/revalidate',
          headers: [
              { key: 'Access-Control-Allow-Credentials', value: 'true' },
              { key: 'Access-Control-Allow-Origin', value: '*' },
              { key: 'Access-Control-Allow-Methods', value: 'GET' },
              { key: 'Access-Control-Allow-Headers', value: 'X-CSRF-Token, X-Requested-With, Accept, Accept-Version, Content-Length, Content-MD5, Content-Type, Date, X-Api-Version, Authorization' }
          ]
        }
    ]
  }
}

module.exports = nextConfig
