import {
  ValidatorConstraint,
  ValidatorConstraintInterface
} from 'class-validator';

@ValidatorConstraint({ name: 'username', async: false })
export class Username implements ValidatorConstraintInterface {
  validate(text: string) {
    if (!text) {
      return false;
    }

    // allow latin character and number only
    // todo - should allow others?
    return /^[a-zA-Z0-9]+$/.test(text);
  }

  defaultMessage() {
    return 'Username is invalid, Special Characters are not allowed.';
  }
}
