import { Injectable, Logger } from '@nestjs/common';
import { InjectModel } from '@nestjs/mongoose';
import { Model } from 'mongoose';

import { StatsUpdatePayload } from 'src/payloads';
import { Stat, StatDocument } from 'src/schemas';

@Injectable()
export class StatsService {
  private logger = new Logger(StatsService.name);

  constructor(
    @InjectModel(Stat.name) private readonly StatModel: Model<StatDocument>
  ) { }

  public async stats() {
    return this.StatModel.findOne({});
  }

  public async updateStats(payload: StatsUpdatePayload) {
    try {
      const { type, value, field } = payload;
      if (!type || !field) {
        return;
      }
      const fieldToUpdate = `${type}.${field}`;

      await this.StatModel.updateOne({}, {
        $set: {
          [fieldToUpdate]: value
        }
      });
    } catch (e) {
      this.logger.error(e);
    }
  }

  public async updateMultiStats(update: Record<string, any>) {
    try {
      if (!update || !Object.keys(update).length) {
        return;
      }
      await this.StatModel.updateOne({}, {
        $set: update
      });
    } catch (e) {
      this.logger.error(e);
    }
  }
}
