import { Inject, Injectable, forwardRef } from '@nestjs/common';
import { ObjectId } from 'mongodb';

import { REACTION_TYPE } from 'src/constants';
import { ProfileDto } from 'src/dtos';
import { ReactionUpdateStatsPayload } from 'src/payloads';

import { AbstractReaction } from './abstract-reacttion.service';
import { PerformerReactionService } from '../performer';
import { VideoReactionService } from '../video';


@Injectable()
export class ReactionObjectService {
  constructor(
    @Inject(forwardRef(() => PerformerReactionService))
    private readonly performerReactionService: PerformerReactionService,
    @Inject(forwardRef(() => VideoReactionService))
    private readonly videoReactionService: VideoReactionService
  ) { }

  public getObjectService(objectType: string): AbstractReaction {
    switch (objectType) {
      case REACTION_TYPE.PERFORMER:
        return this.performerReactionService;
      case REACTION_TYPE.VIDEO:
        return this.videoReactionService;
      default:
        throw new Error('This object not support yet!');
    }
  }

  public async getObjectInfo(objectType: string, ids: string[] | ObjectId[], user?: ProfileDto) {
    const service = this.getObjectService(objectType);

    const data = await service.getReactionObjectInfo(ids, user);
    return data;
  }

  public async updateStats(objectType: string, objectId: string | ObjectId, payload: ReactionUpdateStatsPayload) {
    const service = this.getObjectService(objectType);
    await service.handleUpdateStats(objectId, payload);
  }
}
