import { ObjectId } from 'mongodb';

import { ProfileDto } from 'src/dtos';
import { IGetReactionObjectInfoResponse, IUpdateObjectStats } from 'src/interfaces';
import { ReactionUpdateStatsPayload } from 'src/payloads';

export abstract class AbstractReaction {
  abstract getReactionObjectInfo(ids: string[] | ObjectId[], user?: ProfileDto): Promise<IGetReactionObjectInfoResponse>;
  abstract handleUpdateStats(objectId: string | ObjectId, payload: ReactionUpdateStatsPayload): Promise<IUpdateObjectStats>;
}

