import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { HydratedDocument } from 'mongoose';

@Schema()
export class VideoAds {
  @Prop({
    index: true
  })
  name: string;

  @Prop()
  description: string;

  @Prop()
  vastTag: string;

  @Prop()
  textAd: string;

  @Prop()
  ordering: number;

  @Prop({
    default: 'active'
  })
  status: string;

  @Prop({
    default: 'preRoll'
  })
  roll: string;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type VideoAdsDocument = HydratedDocument<VideoAds>;

export const VideoAdsSchema = SchemaFactory.createForClass(VideoAds);
VideoAdsSchema.index({ name: 'text' });
