import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { HydratedDocument } from 'mongoose';

@Schema({
  collection: 'tags'
})
export class Tag {
  @Prop()
  name: string;

  @Prop({
    required: true,
    trim: true
  })
  key: string;

  @Prop({
    default: 'active',
    index: true
  })
  status: string;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;
}

export type TagDocument = HydratedDocument<Tag>;

export const TagSchema = SchemaFactory.createForClass(Tag);

TagSchema.index({ key: 1 }, { unique: true, sparse: true });
