import {
  Prop, Schema, SchemaFactory, raw
} from '@nestjs/mongoose';
import { HydratedDocument } from 'mongoose';

@Schema({
  collection: 'stats'
})

export class Stat {
  @Prop(raw({
    waitingVerifed: { type: Number, default: 0 },
    new: { type: Number, default: 0 },
    total: { type: Number, default: 0 },
    active: { type: Number, default: 0 },
    inactive: { type: Number, default: 0 }
  }))
  video: {
    waitingVerifed: number;
    new: number;
    total: number;
    active: number;
    inactive: number;
  };

  @Prop(raw({
    videoCategories: { type: Number, default: 0 }
  }))
  category: {
    videoCategories: number;
  };

  @Prop(raw({
    total: { type: Number, default: 0 }
  }))
  member: {
    total: number;
  };
}

export type StatDocument = HydratedDocument<Stat>;

export const StatSchema = SchemaFactory.createForClass(Stat);
