import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { HydratedDocument, Types } from 'mongoose';

@Schema({
  collection: 'settings'
})
export class Setting {
  @Prop()
  name: string;

  @Prop()
  description: string;

  @Prop({
    default: 'system',
    required: true,
    index: true
  })
  group: string;

  @Prop({
    index: true,
    required: true
  })
  key: string;

  @Prop({
    required: true,
    type: Types.Map
  })
  value: any;

  @Prop({
    default: false
  })
  public: boolean;

  @Prop()
  extra: string;

  @Prop({
    default: 'text'
  })
  type: string;

  @Prop({
    default: true
  })
  visible: boolean;

  @Prop({
    default: true
  })
  editable: boolean;

  @Prop({
    default: false
  })
  autoload: boolean;

  @Prop({
    type: Types.Map
  })
  meta: Record<string, any>;

  @Prop({
    default: 0
  })
  ordering: number;

  @Prop({
    type: Date,
    default: Date.now
  })
  updatedAt: Date;

  @Prop({
    type: Date,
    default: Date.now
  })
  createdAt: Date;
}

export type SettingDocument = HydratedDocument<Setting>;

export const SettingSchema = SchemaFactory.createForClass(Setting);

SettingSchema.index({ group: 1, key: 1 }, { unique: true });
